//
//  Chap5.h
//  Sinc
//
//  Created by 杉浦 洋 on 2018/04/01.
//  Copyright © 2018年 杉浦 洋. All rights reserved.
//

#ifndef Chap5_h
#define Chap5_h
/*-----------------------------------------------------*/
/*［５］Tukey-Kramer分布               　                */
/*-----------------------------------------------------*/
//分布関数と逆分布関数
double ACDF(double t,int k){ /*漸近分布関数A(t|k)*/
    double R,h,d,S;
    int ne,n,i;
    if(!(2<=k && k<=20)) {return NAN;};
    if(t < 0) {return 0;};
    ne = 11;/*倍精度標準標本点数*/
    R = 8.3;/*半区間*/
    n = ne*ceil(sqrt(k));/*半区間分割数*/
    h = R/n;/*標本点間隔*/
    d = sqrt(2)*t;
    //台形則積分
    S=0;
    for(i=-n;i<=n;i++){
        S+=pow(PhiCDF(1,i*h)-PhiCDF(1,i*h-d),k-1)*phiPDF(1,i*h);
    };
    return k*h*S;
};
double TACDF(double t,int k,int m){ /*分布関数TA(t|k,m)*/
    if(!(2<=k && k<=20)) {return NAN;};
    if(!(m>=2 || m==-1)) {return NAN;};
    if(t < 0) {return 0;};
    if(m == -1) {return ACDF(t,k);};
    return chiIntegralHayter(ACDF,t,k,m);
};

/*100α%点*/
double taFun(int k,int m,double al){/*TA^-1(1-al|k,m)*/
    if(!(2<=k && k<=20)) {return NAN;};
    if(!(m>=2 || m==-1)) {return NAN;};
    return SecantHayter(TACDF,k,m,al);
};

double aFun(int k,double al){/*TA^-1(1-al|k,m)*/
    return taFun(k,-1,al);
};

//表関数(T1型)
double** taTab(int k,int m,double al){/*taFunのT1型表配列*/
    return MakeTabT1td(taFun,k,m,al);
};
double** aTab(int k,double al){/*aFunのT1型表配列*/
    return MakeTabT1td(taFun,k,-1,al);
};
#endif /* Chap5_h */
